import 'package:photogram_admin_cp/ui/pages/content/storage_options.dart';
import 'package:rad/rad.dart';
import 'package:rad/widgets_html.dart';

import 'package:photogram_admin_cp/import/core.dart';

import 'package:photogram_admin_cp/ui/components/side_navigation.dart';
import 'package:photogram_admin_cp/ui/pages/administration/manage_credentials.dart';
import 'package:photogram_admin_cp/ui/pages/administration/site_settings.dart';
import 'package:photogram_admin_cp/ui/pages/content/auto_feed_tweaking.dart';
import 'package:photogram_admin_cp/ui/pages/content/upload_settings.dart';
import 'package:photogram_admin_cp/ui/pages/security/email_verification.dart';
import 'package:photogram_admin_cp/ui/pages/security/mailer_settings.dart';
import 'package:photogram_admin_cp/ui/pages/security/otp_settings.dart';
import 'package:photogram_admin_cp/ui/pages/search/user_search_page.dart';
import 'package:photogram_admin_cp/ui/pages/dashboard/dashboard_page.dart';
import 'package:photogram_admin_cp/ui/pages/user/user_page.dart';
import 'package:photogram_admin_cp/config.dart';
import 'package:photogram_admin_cp/ui/components/bottom_navigation.dart';
import 'package:photogram_admin_cp/ui/components/top_navigation.dart';

class HomeScreen extends StatefulWidget {
  const HomeScreen({Key? key}) : super(key: key);

  @override
  _HomeScreenState createState() => _HomeScreenState();
}

class _HomeScreenState extends State<HomeScreen> with AppActiveContentMixin {
  NavigatorState? _state;
  String _currentRoute = 'dashboard';

  @override
  build(context) {
    return Division(
      className: 'page-wrapper with-navbar with-sidebar with-navbar-fixed-bottom with-transitions'
          ' animate__animated animate__fadeIn',
      additionalAttributes: const {'data-sidebar-type': 'default'},
      children: [
        const Division(className: 'sticky-alerts'),
        TopNavigation(clientVersion: APP_CLIENT_VERSION),
        SideNavigation(currentRoute: _currentRoute, routeChanger: _openRoute),
        navigatorContent(),
        BottomNavigation(onPanelTextTapEventListener: (event) => _openRoute('dashboard'))
      ],
    );
  }

  Widget navigatorContent() {
    return Division(
      className: "content-wrapper no-select",
      child: Navigator(
        key: const Key('home-screen-navigator'),
        onInit: (state) => _state = state,
        onRouteChange: _onRouteChange,
        routes: const [
          Route(name: 'dashboard', page: DashboardPage()),
          Route(name: 'uploads', page: UploadSettingsPage()),
          Route(name: 'storage', page: StorageOptionsPage()),
          Route(name: 'aft', page: AutoFeedTweaking()),
          Route(name: 'mailer', page: MailerSettingsPage()),
          Route(name: 'otps', page: OTPSettingsPage()),
          Route(name: 'verification', page: EmailVerificationPage()),
          Route(name: 'site', page: SiteSettingsPage()),
          Route(name: 'credentials', page: ManageCredentialsPage()),
          Route(name: 'search', page: UserSearchPage()),
          Route(name: 'user', page: UserPage()),
        ],
      ),
    );
  }

  void _openRoute(String name, [Map<String, String> values = const {}]) {
    _state?.open(name: name, values: values);
  }

  void _onRouteChange(String name) {
    Future.delayed(Duration.zero, () {
      setState(() {
        _currentRoute = name;
      });
    });
  }
}
